using gov.va.med.vbecs.Common;
using System;
using System.Collections.Generic;
using System.Linq;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// PendingSpecimenDatModel
    /// </summary>
    public class PendingSpecimenDatModel : PendingTestModel, IPendingSpecimenTestModel
    {
        /// <summary>
        /// PatientSpecimenGuid
        /// </summary>
        public Guid PatientSpecimenGuid { get; set; }
        /// <summary>
        /// SpecimenUid
        /// </summary>
        public string SpecimenUid { get; set; }
        /// <summary>
        /// OrderedTest
        /// </summary>
        public OrderedTest OrderedTest { get; set; }
        /// <summary>
        /// SpecimenResultSetGuid
        /// </summary>
        public Guid ResultSetGuid { get; set; }
        /// <summary>
        /// SpecimenExpirationDate
        /// </summary>
        public DateTime? SpecimenExpirationDate { get; set; }
        /// <summary>
        /// CprsOrderNumber
        /// </summary>
        public string CprsOrderNumber { get; set; }
        /// <summary>
        /// InterpText
        /// </summary>
        public override string InterpText
        {
            get
            {
                if (Interp != null)
                {
                    return Interp.TestResultText;
                }

                return "";
            }
        }
        /// <summary>
        /// WorkloadProcessID
        /// </summary>
        public override WorkloadProcessID WorkloadProcessId
        {
            get
            {
                return WorkloadProcessID.AutomatedDAT;
            }
        }
        /// <summary>
        /// Result
        /// </summary>
        public PendingTestResultModel Result
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.DAT_Poly_AHG,
                    TestType.DAT_lgG_AHG,
                    TestType.DAT_Comp_AHG,
                    TestType.DATRepeat_Poly_AHG,
                    TestType.DATRepeat_lgG_AHG,
                    TestType.DATRepeat_Comp_AHG,
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// Interp
        /// </summary>
        public PendingTestResultModel Interp
        {
            get
            {
                return TestResultList.FirstOrDefault(x => x.IsInterp);
            }
        }

        /// <summary>
        /// Validate Test
        /// </summary>
        public TestValidationModel Validate()
        {
            return BOL.TestValidation.ValidatePatientDAT(
                        Result == null ? string.Empty : Result.TestResultId,
                        Interp == null ? string.Empty : Interp.TestResultId,
                        OrderedTest,
                        SpecimenExpirationDate);
        }
    }
}



